<?php

namespace App\Entity;

use App\Repository\SqrDataRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=SqrDataRepository::class)
 */
class SqrData
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="integer")
     */
    private $A;// série

    /**
     * @ORM\Column(type="integer")
     */
    private $B; //famille

    /**
     * @ORM\Column(type="integer")
     */
    private $C;// groupe

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $sqr_code;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $approot;

    /**
     * @ORM\Column(type="string", length=50)
     */
    private $NIU;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $proprietaire;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $document;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $statut;

    /**
     * @ORM\Column(type="date")
     */
    private $date_creation;

    /**
     * @ORM\Column(type="date")
     */
    private $date_modification;

    /**
     * @ORM\OneToMany(targetEntity=SqrDataDetail::class, mappedBy="sqrData")
     */
    private $sqrDataDetails;
    
    /**
     * @ORM\Column(type="json", nullable=true)
     */
    private $donnees = [];

    public function __construct()
    {
        $this->sqrDataDetails = new ArrayCollection();
    }

    /* Methods */

    public function addDonnees($data)
    {
        array_push($this->donnees, $data);
    }

    public function lastDonnees()
    {
        //$sqrData = clone($this);
        $lastData = end($this->donnees);
        //dump($lastData);die;
        unset($lastData["cle"]);
        unset($lastData["pieceqr"]);
        unset($lastData["proprietaire"]);
        //$sqrData->setDonnees($lastData);
        //$array = [0 => "a", 1 => "b", 2 => "c"];
        //$dataFinal = \array_diff($lastData, ["cle"=>"xy", "pieceqr"=>"xy", "proprietaire"=>"xy"]);
        return $lastData;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getA(): ?int
    {
        return $this->A;
    }

    public function setA(int $A): self
    {
        $this->A = $A;

        return $this;
    }

    public function getB(): ?int
    {
        return $this->B;
    }

    public function setB(int $B): self
    {
        $this->B = $B;

        return $this;
    }

    public function getC(): ?int
    {
        return $this->C;
    }

    public function setC(int $C): self
    {
        $this->C = $C;

        return $this;
    }

    public function getSqrCode(): ?string
    {
        return $this->sqr_code;
    }

    public function setSqrCode(string $sqr_code): self
    {
        $this->sqr_code = $sqr_code;

        return $this;
    }

    public function getApproot(): ?string
    {
        return $this->approot;
    }

    public function setApproot(string $approot): self
    {
        $this->approot = $approot;

        return $this;
    }

    public function getProprietaire(): ?string
    {
        return $this->proprietaire;
    }

    public function setProprietaire(string $proprietaire): self
    {
        $this->proprietaire = $proprietaire;

        return $this;
    }

    public function getDocument(): ?string
    {
        return $this->document;
    }

    public function setDocument(string $document): self
    {
        $this->document = $document;

        return $this;
    }

    public function getStatut(): ?string
    {
        return $this->statut;
    }

    public function setStatut(string $statut): self
    {
        $this->statut = $statut;

        return $this;
    }

    public function getDateCreation(): ?\DateTimeInterface
    {
        return $this->date_creation;
    }

    public function setDateCreation(\DateTimeInterface $date_creation): self
    {
        $this->date_creation = $date_creation;

        return $this;
    }

    public function getDateModification(): ?\DateTimeInterface
    {
        return $this->date_modification;
    }

    public function setDateModification(\DateTimeInterface $date_modification): self
    {
        $this->date_modification = $date_modification;

        return $this;
    }

    public function getNIU(): ?string
    {
        return $this->NIU;
    }

    public function setNIU(string $NIU): self
    {
        $this->NIU = $NIU;

        return $this;
    }

    public function getDonnees(): ?array
    {
        return $this->donnees;
    }

    public function setDonnees(?array $donnees): self
    {
        $this->donnees = $donnees;

        return $this;
    }

    /**
     * @return Collection<int, SqrDataDetail>
     */
    public function getSqrDataDetails(): Collection
    {
        return $this->sqrDataDetails;
    }

    public function addSqrDataDetail(SqrDataDetail $sqrDataDetail): self
    {
        if (!$this->sqrDataDetails->contains($sqrDataDetail)) {
            $this->sqrDataDetails[] = $sqrDataDetail;
            $sqrDataDetail->setSqrData($this);
        }

        return $this;
    }

    public function removeSqrDataDetail(SqrDataDetail $sqrDataDetail): self
    {
        if ($this->sqrDataDetails->removeElement($sqrDataDetail)) {
            // set the owning side to null (unless already changed)
            if ($sqrDataDetail->getSqrData() === $this) {
                $sqrDataDetail->setSqrData(null);
            }
        }

        return $this;
    }
}
